def solve():
    """
    Решает задачу о раскраске прямоугольной дороги.
    Считывает n, m и k из стандартного ввода и выводит количество клеток каждого цвета.
    """
    try:
        line1 = input().split()
        if not line1:
            return

        # Handle different input styles (separate lines or one line)
        if len(line1) == 3:
            n, m, k = int(line1[0]), int(line1[1]), int(line1[2])
        elif len(line1) == 1:
            n = int(line1[0])
            m = int(input())
            k = int(input())
        else:
            return # Invalid input

        counts_cycle = [0] * k
        for i in range(1, k + 1):
            start_color = (i - 1) % k
            full_cycles = m // k
            remaining = m % k
            for c in range(k):
                counts_cycle[c] += full_cycles
            for j in range(remaining):
                counts_cycle[(start_color + j) % k] += 1
        
        counts = [0] * k
        full_n_cycles = n // k
        for c in range(k):
            counts[c] = counts_cycle[c] * full_n_cycles
        
        remaining_n_rows = n % k
        for i in range(1, remaining_n_rows + 1):
            start_color = (i - 1) % k
            full_cycles = m // k
            remaining = m % k
            for c in range(k):
                counts[c] += full_cycles
            for j in range(remaining):
                counts[(start_color + j) % k] += 1
                
        # Output the counts as requested
        print(*(counts))

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()
