def count_magic(X):
    if X < 7:
        return 0
    
    # Numbers divisible by 7: floor(X / 7)
    count_div7 = X // 7
    
    # Numbers ending in 7: numbers are 7, 17, 27, ..., (10*m + 7) <= X
    # (10*m + 7) <= X => 10*m <= X - 7 => m <= (X - 7) / 10
    # m starts from 0. Count is floor((X - 7) / 10) + 1
    count_end7 = (X - 7) // 10 + 1
    
    # Numbers divisible by 7 AND ending in 7 (numbers 7, 77, 147, ...)
    # Numbers are of form 70*j + 7
    # (70*j + 7) <= X => 70*j <= X - 7 => j <= (X - 7) / 70
    # j starts from 0. Count is floor((X - 7) / 70) + 1
    count_both = (X - 7) // 70 + 1
    
    # Total magic numbers using inclusion-exclusion principle
    return count_div7 + count_end7 - count_both

def find_kth_magic(k):
    # Set appropriate binary search boundaries.
    # The density is roughly 1/7 + 1/10 - 1/70 ~= 0.228
    # Max possible answer for k=10^17 is roughly 10^17 * 10
    left, right = 1, 2 * 10**17
    
    while left < right:
        mid = (left + right) // 2
        if count_magic(mid) >= k:
            right = mid
        else:
            left = mid + 1
            
    return left

# Reading input
import sys
try:
    line = sys.stdin.readline()
    if line:
        k = int(line)
        result = find_kth_magic(k)
        print(result)
except EOFError:
    pass
except ValueError:
    pass
