#include <iostream>
#include <cmath>
#include <vector>

long RoundRooted(double x) {
    if(x==1) return 1;
    for(int i = 2; i < 4; i++) {
        float val;
        if(i == 2) {val = sqrt(x);}
        if(i == 3) {val = cbrt(x);}
        
        if(val - (int)val == 0) {
            return i % 2 == 1;
        }
    }
    return 1;
}

bool isOddRooted(int x) {
    for(float i = 2.0f; i < 10000.0f; i++) {
        float res = x / i;
        if(res - (int)res == 0) {
            if(res == 1) return true;
            if(res*res == x) return false;
            if(RoundRooted(res)*RoundRooted(i)) return true;
            break;
        }
    }
    return false;
}

int main() {
    int m;
    int l;
    int r;

    std::cin >> m;
    std::cin >> l;
    std::cin >> r;

    std::vector<int> folws;
    int c;

    for(int i = l; i < r; i++) {
        if(isOddRooted(i)) {
            folws.push_back(i);
            c++;
            if(c == m) {
                for(int i = 0; i < m; i++) {
                    std::cout << folws[i];
                    if(i != m-1) std::cout << " ";
                }
                std::cout << std::endl;
                return 0;
            }
        } else {
            folws.clear();
            c = 0;
        }
    }

    std::cout << -1 << std::endl;

    return 0;
}