MOD = 10 ** 9 + 7


def solve():
    import sys
    n, K = map(int, sys.stdin.readline().split())
    R_str = sys.stdin.readline().strip()

    # Особые случаи
    if K == 1:
        # Все числа подходят: popcount(x) mod 1 == 0 всегда
        R_val = int(R_str)
        print((R_val + 1) % MOD)
        return

    if R_str == "0":
        print(1)  # только x=0
        return

    # Переводим R в двоичную строку
    R_val = int(R_str)
    binary_R = bin(R_val)[2:]  # без префикса '0b'
    L = len(binary_R)

    # DP с мемоизацией
    from functools import lru_cache

    @lru_cache(maxsize=None)
    def dp(pos, tight, cnt):
        if pos == L:
            return 1 if (cnt % K) == 0 else 0

        limit = 1
        if tight:
            limit = int(binary_R[pos])

        total = 0
        for b in range(0, limit + 1):
            new_tight = tight and (b == limit)
            new_cnt = (cnt + b) % K
            total = (total + dp(pos + 1, new_tight, new_cnt)) % MOD

        return total

    result = dp(0, True, 0)
    print(result)


solve()


