import sys

def main():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX = 10**6

    # Шаг 1. Предподсчёт наименьшего простого делителя (spf)
    spf = list(range(MAX + 1))  # spf[x] = наименьший простой делитель x
    for i in range(2, int(MAX**0.5) + 1):
        if spf[i] == i:  # i — простое
            for j in range(i * i, MAX + 1, i):
                if spf[j] == j:
                    spf[j] = i

    # Шаг 2. Для каждого x от 2 до MAX проверяем, нечётно-степенное ли оно
    is_odd_power = [False] * (MAX + 1)
    for x in range(2, MAX + 1):
        temp = x
        all_odd = True
        while temp > 1:
            p = spf[temp]
            cnt = 0
            while temp % p == 0:
                cnt += 1
                temp //= p
            if cnt % 2 == 0:
                all_odd = False
                break
        is_odd_power[x] = all_odd

    # Шаг 3. Ищем m подряд идущих нечётно-степенных чисел в [l, r]
    count = 0
    result = []
    for x in range(l, r + 1):
        if is_odd_power[x]:
            count += 1
            result.append(x)
            if count == m:
                print(' '.join(map(str, result)))
                return
        else:
            count = 0
            result = []

    print(-1)

if __name__ == '__main__':
    main()

