import sys

def main():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX = 10**6

    # Шаг 1. Создаём массив, изначально все числа — нечётно-степенные
    is_odd_power = [True] * (MAX + 1)
    is_odd_power[0] = False  # 0 не натуральное
    is_odd_power[1] = True  # 1 = пустое разложение → условно считаем нечётно-степенным

    # Но по условию n ≥ 2, так что 1 не влияет

    # Однако в задаче l ≥ 2, так что можно не заботиться о 1

    # Шаг 2. Для каждого простого p отметим числа, делящиеся на p^k, где k ≥ 2 и чётное
    # Будем перебирать p от 2 до sqrt(MAX)
    for p in range(2, int(MAX**0.5) + 1):
        if not is_odd_power[p]:
            continue  # p не простое (уже отмечено)
        # Перебираем чётные степени: k = 2, 4, 6, ...
        power = p * p  # p^2
        while power <= MAX:
            # Отмечаем все числа, делящиеся на power, как не нечётно-степенные
            for multiple in range(power, MAX + 1, power):
                is_odd_power[multiple] = False
            # Следующая чётная степень: p^4, p^6, ...
            power *= p * p  # умножаем на p^2 → p^(k+2)


    # Теперь is_odd_power[x] == True ⇔ x — нечётно-степенное

    # Шаг 3. Ищем последовательность длины m в [l; r]
    count = 0
    start = -1
    for x in range(l, r + 1):
        if is_odd_power[x]:
            count += 1
            if count == m:
                start = x - m + 1
                break
        else:
            count = 0  # сброс счётчика


    if start == -1:
        print(-1)
    else:
        # Выводим m чисел: start, start+1, ..., start+m-1
        print(' '.join(map(str, range(start, start + m))))

if __name__ == '__main__':
    main()



