import sys

def solve_rectangles(n, rectangles):
    if n == 1:
        return True
    
    min_x_left = float('inf')
    max_x_left = -float('inf')
    min_y_bottom = float('inf')
    max_y_bottom = -float('inf')
    min_x_right = float('inf')
    max_x_right = -float('inf')
    min_y_top = float('inf')
    max_y_top = -float('inf')
    
    min_b1 = -float('inf')
    max_b1 = float('inf')
    min_b2 = -float('inf')
    max_b2 = float('inf')
    
    for x1, y1, x2, y2 in rectangles:
        min_x_left = min(min_x_left, x2)
        max_x_left = max(max_x_left, x1)
        min_x_right = min(min_x_right, x2)
        max_x_right = max(max_x_right, x1)
        min_y_bottom = min(min_y_bottom, y2)
        max_y_bottom = max(max_y_bottom, y1)
        min_y_top = min(min_y_top, y2)
        max_y_top = max(max_y_top, y1)
        
        min_b1 = max(min_b1, y1 - x2)
        max_b1 = min(max_b1, y2 - x1)
        min_b2 = max(min_b2, y1 + x1)
        max_b2 = min(max_b2, y2 + x2)
    
    if max_x_left <= min_x_left:
        return True
    if max_y_bottom <= min_y_bottom:
        return True
    if min_b1 <= max_b1:
        return True
    if min_b2 <= max_b2:
        return True
    
    return False

def main():
    data = sys.stdin.read().strip().split()
    t = int(data[0])
    idx = 1
    results = []
    
    for _ in range(t):
        n = int(data[idx])
        idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx])
            y1 = int(data[idx+1])
            x2 = int(data[idx+2])
            y2 = int(data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        
        if solve_rectangles(n, rects):
            results.append("Yes")
        else:
            results.append("No")
    
    sys.stdout.write("\n".join(results))

if __name__ == "__main__":
    main()
