def count_numbers(R, K):
    MOD = 10 ** 9 + 7
    binary_R = bin(R)[2:]
    n = len(binary_R)

    # dp[pos][count][tight]
    dp = [[[-1 for _ in range(2)] for _ in range(K)] for _ in range(n + 1)]

    def dfs(pos, count, tight):
        if pos == n:
            return 1 if count % K == 0 else 0

        if dp[pos][count][tight] != -1:
            return dp[pos][count][tight]

        limit = int(binary_R[pos]) if tight else 1
        result = 0

        for digit in range(0, limit + 1):
            result += dfs(pos + 1, count + digit, tight and (digit == limit))
            result %= MOD

        dp[pos][count][tight] = result
        return result

    return dfs(0, 0, 1)


n, K = map(int, input().strip().split())
R = int(input().strip())

result = count_numbers(R, K)
print(result)
