import sys

data = sys.stdin.read().strip().split()
m = int(data[0])
l = int(data[1])
r = int(data[2])

max_n = r
is_odd_power = [True] * (max_n + 1)
is_odd_power[0] = is_odd_power[1] = False

# Решето
for i in range(2, max_n + 1):
    if is_odd_power[i]:
        power = 2
        while i ** power <= max_n:
            for j in range(i ** power, max_n + 1, i ** power):
                is_odd_power[j] = False
            power += 2

# Поиск последовательности
consecutive = 0
start_pos = -1

for i in range(l, r + 1):
    if is_odd_power[i]:
        consecutive += 1
        if consecutive >= m:
            start_pos = i - m + 1
            break
    else:
        consecutive = 0

if start_pos == -1:
    print(-1)
else:
    result = list(range(start_pos, start_pos + m))
    print(' '.join(map(str, result)))
