def is_odd_power_number(n):
    if n < 2:
        return False
    for p in range(2, int(n ** 0.5) + 1):
        if n % (p * p) == 0:
            return False
        while n % p == 0:
            n //= p
    return True


def find_consecutive_odd_power_numbers(m, l, r):
    odd_power_numbers = []

    for i in range(l, r + 1):
        if is_odd_power_number(i):
            odd_power_numbers.append(i)
    for i in range(len(odd_power_numbers) - m + 1):
        if odd_power_numbers[i + m - 1] - odd_power_numbers[i] == m - 1:
            return odd_power_numbers[i:i + m]

    return -1


m = int(input().strip())
l, r = map(int, input().strip().split())
result = find_consecutive_odd_power_numbers(m, l, r)
if result == -1:
    print(-1)
else:
    print(" ".join(map(str, result)))
