import sys

def solve():
    """
    Рассчитывает количество клеток каждого цвета в n x m сетке
    с диагональной раскраской по k цветам.
    """
    try:
        # Чтение входных данных из стандартного ввода
        # Ожидаем, что числа могут быть разделены пробелами или переводами строк
        data = sys.stdin.read().strip().split()
        if not data:
            return

        n = int(data)
        m = int(data)
        k = int(data)

    except (IndexError, ValueError):
        # Обработка ошибок ввода, если данные неполные или некорректны
        return

    # Убеждаемся, что n <= m для упрощения логики алгоритма
    if n > m:
        n, m = m, n

    # Массив для хранения итогового количества клеток каждого из k цветов (индексация с 0)
    colors_count = [0] * k
    
    # --- Расчет для первой области (длины диагоналей от 1 до n) ---
    
    # Определяем, сколько раз полный цикл цветов k повторяется
    full_cycles = (n - 1) // k
    remaining = (n - 1) % k
    
    for c in range(k):
        # Количество диагоналей цвета c в этой области
        count_of_diagonals = full_cycles
        if c < remaining:
            count_of_diagonals += 1
        
        if count_of_diagonals > 0:
            # Сумма длин арифметической прогрессии для данного цвета
            a1 = c + 1  # Длина первой диагонали этого цвета
            an = a1 + (count_of_diagonals - 1) * k # Длина последней диагонали этого цвета
            # S = count * (a1 + an) / 2
            colors_count[c] += count_of_diagonals * (a1 + an) // 2

    # --- Расчет для второй области (длины диагоналей = n, от n до m) ---

    # Количество диагоналей в этой области
    num_middle_diagonals = m - n + 1
    
    # Индекс цвета первой диагонали в этой области ((n-1) % k)
    start_color_index = (n - 1) % k
    
    # Распределяем клетки по цветам
    for i in range(num_middle_diagonals):
        current_color_index = (start_color_index + i) % k
        colors_count[current_color_index] += n # Длина всех диагоналей здесь равна n

    # --- Расчет для третьей области (длины диагоналей от n-1 до 1) ---
    
    # Используем симметрию первой области, но со смещенным стартовым цветом
    num_last_section = n - 1
    full_cycles = num_last_section // k
    remaining = num_last_section % k

    # Индекс цвета первой диагонали в третьей области ((m) % k)
    start_color_index_third = m % k
    
    for c in range(k):
        # Количество диагоналей цвета c в этой области (по длинам 1..n-1)
        count_of_diagonals = full_cycles
        if c < remaining:
            count_of_diagonals += 1
        
        if count_of_diagonals > 0:
            # Суммируем длины так же, как в первой области
            a1 = c + 1
            an = a1 + (count_of_diagonals - 1) * k
            sum_of_lengths = count_of_diagonals * (a1 + an) // 2
            
            # Определяем, к какому реальному цвету в третьей области это относится
            real_color_index = (start_color_index_third + c) % k
            colors_count[real_color_index] += sum_of_lengths

    # Вывод результатов
    print(*(colors_count))

if __name__ == "__main__":
    solve()
