def get_lb_tr(x0,y0,x1,y1):
    return [(min(x0,x1), min(y0, y1)), (max(x0,x1), max(y0, y1))]
def get_bs(main):
    b1 = main[0][1] - main[0][0]
    b2 = main[1][1] - main[1][0]
    b3 = main[0][1] - main[1][0]
    b4 = main[1][1] - main[0][0]
    b = (b1, b2, b3, b4)
    return b
def find_intersection(a1,a2,b1,b2):
    if a1>b2:
        return a1,b2
    if b1>a2:
        return b1,a2
    t = [a1,a2,b1,b2]
    t.sort()
    return t[1], t[2]


def get_ranges(r1, r2):
    vl, vb = find_intersection(r1[0][0], r1[1][0], r2[0][0],r2[1][0])
    hl, hb = find_intersection(r1[0][1], r1[1][1], r2[0][1],r2[1][1])
    b = get_bs(r2)
    pl = nl = min(b)
    pb = nb = max(b)
    return vl,vb,hl,hb,pl,pb,nl,nb
    
def solve():
    n = int(input())
    main = list(map(int, input().split()))
    main = get_lb_tr(*main)

    b = get_bs(main)
    others = []
    for _ in range(n-1):
        other = list(map(int, input().split()))
        other = get_lb_tr(*other)
        others.append(other)
    if n<=2:
        print('Yes')
        return
    
    hor_least = -float('inf')
    hor_biggest = float('inf')
    ver_least = -float('inf')
    ver_biggest = float('inf')

    pos_least = min(b)
    pos_biggest = max(b)
    neg_least = min(b)
    neg_biggest = max(b)
    
    for rect in others:
        vl,vb,hl,hb,pl,pb,nl,nb = get_ranges(main, rect)
        if hor_least<=hor_biggest:
            hor_least, hor_biggest = find_intersection(hor_least, hor_biggest, hl, hb)
        if ver_least<=ver_biggest:
            ver_least, ver_biggest = find_intersection(ver_least, ver_biggest, vl, vb)
        if pos_least<=pos_biggest:
            pos_least, pos_biggest = find_intersection(pos_least, pos_biggest, pl, pb)
        if neg_least<=neg_biggest:
            neg_least, neg_biggest = find_intersection(neg_least, neg_biggest, nl, nb)
    if hor_least<=hor_biggest or ver_least<=ver_biggest or pos_least<=neg_biggest or neg_least<=neg_biggest:
        print('Yes')
    else:
        print('No')
for _ in range(int(input())):
    solve()
