def get_lb_tr(x0,y0,x1,y1):
    return [(min(x0,x1), min(y0, y1)), (max(x0,x1), max(y0, y1))]

def find_intersection(a1,a2,b1,b2):
    if a1>b2:
        return a1,b2
    if b1>a2:
        return b1,a2
    t = [a1,a2,b1,b2]
    t.sort()
    return t[1], t[2]


def get_ranges(r1, r2):
    vl, vb = find_intersection(r1[0][0], r1[1][0], r2[0][0],r2[1][0])
    hl, hb = find_intersection(r1[0][1], r1[1][1], r2[0][1],r2[1][1])
    
    return vl,vb,hl,hb
    
def solve():
    n = int(input())
    if n<=2:
        print('Yes')
        return
    main = list(map(int, input().split()))
    main = get_lb_tr(*main)
    
    others = []
    for _ in range(n-1):
        other = list(map(int, input().split()))
        other = get_lb_tr(*other)
        others.append(other)

    hor_least = -float('inf')
    hor_biggest = float('inf')
    ver_least = -float('inf')
    ver_biggest = float('inf')

    for rect in others:
        vl,vb,hl,hb = get_ranges(main, rect)
        if hor_least<=hor_biggest:
            hor_least, hor_biggest = find_intersection(hor_least, hor_biggest, hl, hb)
        if ver_least<=ver_biggest:
            ver_least, ver_biggest = find_intersection(ver_least, ver_biggest, vl, vb)
    if hor_least<=hor_biggest or ver_least<=ver_biggest:
        print('Yes')
    else:
        print('No')
for _ in range(int(input())):
    solve()
