import java.util.Scanner;

public class main{
    static class Rect {
        long x1, y1, x2, y2;
        Rect(long x1, long y1, long x2, long y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int T = sc.nextInt();
        
        while (T-- > 0) {
            int n = sc.nextInt();
            Rect[] rects = new Rect[n];
            for (int i = 0; i < n; i++) {
                long x1 = sc.nextLong();
                long y1 = sc.nextLong();
                long x2 = sc.nextLong();
                long y2 = sc.nextLong();
                rects[i] = new Rect(x1, y1, x2, y2);
            }
            
            System.out.println(canCoverAll(rects) ? "Yes" : "No");
        }
        sc.close();
    }

    private static boolean canCoverAll(Rect[] rects) {
        int n = rects.length;
        if (n <= 2) return true;


        // Проверим все пары первых трёх прямоугольников — через них может проходить искомая прямая
        for (int i = 0; i < 3; i++) {
            for (int j = i + 1; j < 3; j++) {
                if (tryLineThroughTwo(rects[i], rects[j], rects)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean tryLineThroughTwo(Rect r1, Rect r2, Rect[] all) {
        // Генерируем кандидаты в опорные точки на границах прямоугольников
        long[][] pts1 = getBoundaryPoints(r1);
        long[][] pts2 = getBoundaryPoints(r2);

        for (long[] p1 : pts1) {
            for (long[] p2 : pts2) {
                if (p1[0] == p2[0] && p1[1] == p2[1]) continue; // одна точка — не прямая
                if (coversAll(p1, p2, all)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static long[][] getBoundaryPoints(Rect r) {
        return new long[][]{
            {r.x1, r.y1},
            {r.x1, r.y2},
            {r.x2, r.y1},
            {r.x2, r.y2}
        };
    }

    private static boolean coversAll(long[] p1, long[] p2, Rect[] rects) {
        long dx = p2[0] - p1[0];
        long dy = p2[1] - p1[1];

        for (Rect r : rects) {
            if (!intersects(p1, dx, dy, r)) {
                return false;
            }
        }
        return true;
    }

    private static boolean intersects(long[] p, long dx, long dy, Rect r) {
        // Проверяем, пересекает ли прямая (p, dx,dy) прямоугольник r
        // Прямая: (x - p[0]) * dy == (y - p[1]) * dx


        // Если прямая вертикальная (dx == 0)
        if (dx == 0) {
            return r.x1 <= p[0] && p[0] <= r.x2;
        }

        // Если прямая горизонтальная (dy == 0)
        if (dy == 0) {
            return r.y1 <= p[1] && p[1] <= r.y2;
        }

        // Проверяем пересечение с вертикальными гранями
        boolean left = lineIntersectsVertical(p, dx, dy, r.x1, r.y1, r.y2);
        boolean right = lineIntersectsVertical(p, dx, dy, r.x2, r.y1, r.y2);
        // С горизонтальными
        boolean bottom = lineIntersectsHorizontal(p, dx, dy, r.y1, r.x1, r.x2);
        boolean top = lineIntersectsHorizontal(p, dx, dy, r.y2, r.x1, r.x2);


        return left || right || bottom || top;
    }

    private static boolean lineIntersectsVertical(long[] p, long dx, long dy, long x, long ymin, long ymax) {
        // x = const; подставляем в уравнение прямой
        long tdx = x - p[0];
        // (tdx) * dy == (y - p[1]) * dx  =>  y = p[1] + tdx * dy / dx
        if (dx == 0) return false;
        long num = tdx * dy;
        long den = dx;
        // y = p[1] + num/den
        // Нужно, чтобы y было в [ymin, ymax]
        // num/den в [ymin - p[1], ymax - p[1]]
        long low = (ymin - p[1]) * den;
        long high = (ymax - p[1]) * den;

        if (den > 0) {
            return low <= num && num <= high;
        } else {
            return high <= num && num <= low;
        }
    }

    private static boolean lineIntersectsHorizontal(long[] p, long dx, long dy, long y, long xmin, long xmax) {
        // y = const
        long tdy = y - p[1];
        if (dy == 0) return false;
        long num = tdy * dx;
        long den = dy;
        // x = p[0] + num/den
        long low = (xmin - p[0]) * den;
        long high = (xmax - p[0]) * den;

        if (den > 0) {
            return low <= num && num <= high;
        } else {
            return high <= num && num <= low;
        }
    }
}
