import java.util.Scanner;

public class Main {
    private static final int MOD = 1_000_000_007;

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int n = sc.nextInt();
        int K = sc.nextInt();
        String R = sc.next();
        sc.close();

        if (K == 1) {
            System.out.println((new java.math.BigInteger(R).add(java.math.BigInteger.ONE)).mod(java.math.BigInteger.valueOf(MOD)));
            return;
        }

        int[] digits = new int[n];
        for (int i = 0; i < n; i++) {
            digits[i] = R.charAt(i) - '0';
        }

       
        long[][] dp = new long[K][2];
        dp[0][1] = 1; 


        for (int pos = 0; pos < n; pos++) {
            long[][] nextDp = new long[K][2];


            for (int cntMod = 0; cntMod < K; cntMod++) {
                for (int isTight = 0; isTight <= 1; isTight++) {
                    if (dp[cntMod][isTight] == 0) continue;


                    int upper = isTight == 1 ? digits[pos] : 9;
                    for (int d = 0; d <= upper; d++) {
                        int newIsTight = (isTight == 1 && d == upper) ? 1 : 0;
                        int bitCount = Integer.bitCount(d);
                        int newCntMod = (cntMod + bitCount) % K;


                        nextDp[newCntMod][newIsTight] = (nextDp[newCntMod][newIsTight] + dp[cntMod][isTight]) % MOD;
                    }
                }
            }

            dp = nextDp;
        }

        long result = (dp[0][0] + dp[0][1]) % MOD;
        System.out.println(result);
    }
}
