import java.math.BigInteger;
import java.util.Scanner;

public class main{
    private static final int MOD = 1_000_000_007;

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int n = sc.nextInt();
        int K = sc.nextInt();
        String R = sc.next();
        sc.close();

       
        if (K == 1) {
            System.out.println(new BigInteger(R).add(BigInteger.ONE).mod(BigInteger.valueOf(MOD)));
            return;
        }

        int[] digits = new int[n];
        for (int i = 0; i < n; i++) {
            digits[i] = R.charAt(i) - '0';
        }

        long[][][] dp = new long[n + 1][K][2];
        dp[0][0][1] = 1; 


        for (int pos = 0; pos < n; pos++) {
            for (int cntMod = 0; cntMod < K; cntMod++) {
                for (int isEqual = 0; isEqual <= 1; isEqual++) {
                    if (dp[pos][cntMod][isEqual] == 0) continue;


                    int maxDigit = isEqual == 1 ? digits[pos] : 9;
                    for (int d = 0; d <= maxDigit; d++) {
                        int newIsEqual = (isEqual == 1 && d == digits[pos]) ? 1 : 0;
                        int bitCount = Integer.bitCount(d);
                        int newCntMod = (cntMod + bitCount) % K;

                        dp[pos + 1][newCntMod][newIsEqual] = (
                            dp[pos + 1][newCntMod][newIsEqual] + dp[pos][cntMod][isEqual]
                        ) % MOD;
                    }
                }
            }
        }

        long result = (dp[n][0][0] + dp[n][0][1]) % MOD;
        System.out.println(result);
    }
}
