import java.util.Scanner;

public class OddPowerNumbers {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int m = sc.nextInt();
        int l = sc.nextInt();
        int r = sc.nextInt();
        sc.close();

       
        boolean[] isOddPower = new boolean[r + 1];

        for (int n = 2; n <= r; n++) {
            isOddPower[n] = isOddPowerNumber(n);
        }

        int start = -1;
        for (int i = l; i <= r - m + 1; i++) {
            boolean valid = true;
            for (int j = 0; j < m; j++) {
                if (!isOddPower[i + j]) {
                    valid = false;
                    break;
                }
            }
            if (valid) {
                start = i;
                break;
            }
        }

      
        if (start == -1) {
            System.out.println(-1);
        } else {
            for (int i = 0; i < m; i++) {
                System.out.print(start + i);
                if (i < m - 1) System.out.print(" ");
            }
            System.out.println();
        }
    }

    private static boolean isOddPowerNumber(int n) {
        int temp = n;
        for (int p = 2; p * p <= temp; p++) {
            if (temp % p == 0) {
                int exp = 0;
                while (temp % p == 0) {
                    exp++;
                    temp /= p;
                }
                if (exp % 2 == 0) {
                    return false; 
                }
            }
        }
       
        return true;
    }
}
