﻿#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
using ll = long long;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    ll n, m, k;
    cin >> n >> m >> k;

    vector<ll> count(k, 0);
    ll min_nm = min(n, m);
    ll max_nm = max(n, m);
    ll total_diags = n + m - 1;
    auto sum_arithmetic = [](ll a1, ll an, ll n) {
        return (a1 + an) * n / 2;
    };
    auto process_segment = [&](ll L, ll R, const string& len_type) {
        if (L > R) return;
        for (ll r = 0; r < k; ++r) {
            ll d0 = L + ((r - (L - 1) % k + k) % k);
            if (d0 > R) continue;
            ll dn = d0 + ((R - d0) / k) * k;
            ll N = (dn - d0) / k + 1;
            if (len_type == "1") {
                count[r] += sum_arithmetic(d0, dn, N);
            }
            else if (len_type == "2") {
                count[r] += N * min_nm;
            }
            else if (len_type == "3") {
                ll a1 = n + m - d0;
                ll an = n + m - dn;
                count[r] += sum_arithmetic(a1, an, N);
            }
        }
    };

    process_segment(1, min_nm, "1");
    process_segment(min_nm + 1, max_nm, "2");
    process_segment(max_nm + 1, total_diags, "3");

    for (ll c : count) {
        cout << c << "\n";
    }

    return 0;
}
