import sys


def g():
    """
    Finds the first sequence of m consecutive square-free numbers in the range [l, r]
    using a segmented sieve method for maximum speed in Python.
    """
    try:

        line1 = sys.stdin.readline()
        if not line1: return
        m = int(line1)
        line2 = sys.stdin.readline()
        if not line2: return
        l, r = map(int, line2.split())
    except ValueError:
        return


    limit = r
    range_size = r - l + 1

    is_square_free = [True] * range_size


    i = 2
    while i * i <= limit:
        square = i * i

        start_multiple = (l + square - 1) // square * square

        if start_multiple < square:
            start_multiple += square


        for j in range(start_multiple, r + 1, square):
            is_square_free[j - l] = False

        i += 1


    for start_index in range(range_size - m + 1):

        if all(is_square_free[start_index + k] for k in range(m)):

            sequence = [l + start_index + k for k in range(m)]
            print(*sequence)
            return


    print("-1")
g()
