#include <iostream>
#include <vector>

using namespace std;

bool canPaint(int m, int k, const vector<int>& colors) {
    int totalColors = 0;
    for (int c : colors) {
        totalColors += c / k; 
    }
    return totalColors >= m; 
}

int main() {
    int m, t;
    cin >> m >> t; 

    vector<int> colors(t);
    for (int i = 0; i < t; ++i) {
        cin >> colors[i]; 
    }

   
    int left = 1, right = 1e9;
    int result = -1;

    while (left <= right) {
        int mid = left + (right - left) / 2; 

        if (canPaint(m, mid, colors)) {
            result = mid;
            right = mid - 1; 
        }
        else {
            left = mid + 1; 
        }
    }

    cout << result << endl; 
    return 0;
}
