import sys
from functools import lru_cache

sys.set_int_max_str_digits(200000)

MOD = 10 ** 9 + 7


def f():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return

        parts = list(map(int, line1.split()))
        if not parts:
            line1 = sys.stdin.readline()
            if not line1:
                return
            parts = list(map(int, line1.split()))

        n, K = parts
        R_str = sys.stdin.readline().strip()
        if not R_str:
            return

        # Переводим R из десятичной в двоичную строку
        R_int = int(R_str)
        if R_int == 0:
            print(1 % MOD)
            return

        binary_R = bin(R_int)[2:]
        L = len(binary_R)

        @lru_cache(None)
        def dp(index, is_tight, current_popcount_mod_K):
            if index == L:
                return 1 if current_popcount_mod_K == 0 else 0

            upper_limit = int(binary_R[index]) if is_tight else 1
            count = 0

            for bit in range(upper_limit + 1):
                new_tight = is_tight and (bit == upper_limit)
                new_popcount_mod_K = (current_popcount_mod_K + bit) % K
                count = (count + dp(index + 1, new_tight, new_popcount_mod_K)) % MOD

            return count


        result = dp(0, True, 0)
        dp.cache_clear()


        for length in range(1, L):
            # dp_len[pc_mod_K] - количество чисел длины 'length' с popcount % K == pc_mod_K
            dp_len = [0] * K
            dp_len[0] = 1  # Базовый случай: пустая строка, mod 0
            for _ in range(length):
                next_dp_len = [0] * K
                for pc_mod in range(K):
                    # Добавляем 0
                    next_dp_len[pc_mod] = (next_dp_len[pc_mod] + dp_len[pc_mod]) % MOD
                    # Добавляем 1
                    next_dp_len[(pc_mod + 1) % K] = (next_dp_len[(pc_mod + 1) % K] + dp_len[pc_mod]) % MOD
                dp_len = next_dp_len



        @lru_cache(None)
        def dp_final(index, is_tight, is_started, current_popcount_mod_K):
            if index == L:
                return 1 if current_popcount_mod_K == 0 else 0

            upper_limit = int(binary_R[index]) if is_tight else 1
            count = 0
            for bit in range(upper_limit + 1):
                if not is_started and bit == 0:
                    # Пропускаем ведущие нули, не считаем их popcount
                    count = (count + dp_final(index + 1, is_tight and (bit == upper_limit), False,
                                              current_popcount_mod_K)) % MOD
                else:
                    # Начали число, считаем popcount
                    count = (count + dp_final(index + 1, is_tight and (bit == upper_limit), True,
                                              (current_popcount_mod_K + bit) % K)) % MOD
            return count


        result_final = dp_final(0, True, False, 0)
        print(result_final)

    except EOFError:
        pass
    except ValueError:
        pass


f()
