import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]

    # Переводим R в двоичную строку
    R_int = int(R_str)
    bin_R = bin(R_int)[2:]
    m = len(bin_R)

    # Если K > m, только x = 0 подходит
    if K > m:
        print(1)
        return

    # dp_eq[mod] - числа, совпадающие с префиксом R
    # dp_less[mod] - числа, уже меньшие R
    dp_eq = [0] * K
    dp_less = [0] * K
    dp_eq[0] = 1

    # Предподсчет биномиальных коэффициентов C(l, s) для l <= m
    C = [[0] * (m + 1) for _ in range(m + 1)]
    for i in range(m + 1):
        C[i][0] = C[i][i] = 1
        for j in range(1, i):
            C[i][j] = (C[i - 1][j - 1] + C[i - 1][j]) % MOD

    # Функция для суммы C(L, s) для s ≡ target_mod (mod K)
    def sum_binom_mod(L, target_mod):
        total = 0
        s = target_mod
        while s <= L:
            total = (total + C[L][s]) % MOD
            s += K
        return total

    # Проход по битам R
    for pos in range(m):
        bit = int(bin_R[pos])
        new_dp_eq = [0] * K
        new_dp_less = [0] * K

        if bit == 1:
            # Из dp_eq можно поставить 0 (переход в less)
            for mod in range(K):
                if dp_eq[mod]:
                    L = m - pos - 1
                    # Все варианты для оставшихся битов
                    total = pow(2, L, MOD)  # можно заменить на sum_binom_mod для всех остатков
                    new_dp_less[mod] = (new_dp_less[mod] + dp_eq[mod]) % MOD
            # Из dp_eq можно поставить 1 (остаемся в eq)
            for mod in range(K):
                if dp_eq[mod]:
                    new_mod = (mod + 1) % K
                    new_dp_eq[new_mod] = (new_dp_eq[new_mod] + dp_eq[mod]) % MOD
        else:  # bit == 0
            # Из dp_eq можно поставить только 0 (остаемся в eq)
            for mod in range(K):
                if dp_eq[mod]:
                    new_dp_eq[mod] = (new_dp_eq[mod] + dp_eq[mod]) % MOD

        # Переходы из dp_less
        for mod in range(K):
            if dp_less[mod]:
                # Поставить 0
                new_dp_less[mod] = (new_dp_less[mod] + dp_less[mod]) % MOD
                # Поставить 1
                new_mod = (mod + 1) % K
                new_dp_less[new_mod] = (new_dp_less[new_mod] + dp_less[mod]) % MOD

        dp_eq = new_dp_eq
        dp_less = new_dp_less

    # Ответ: числа с остатком 0 из dp_eq и dp_less
    result = (dp_eq[0] + dp_less[0]) % MOD
    print(result)

if __name__ == "__main__":
    solve()
