def main():
    import sys

    input = sys.stdin.read
    data = input().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    MAX = r + 1

    # Наименьший простой делитель
    spf = list(range(MAX))
    for i in range(2, int(MAX**0.5) + 1):
        if spf[i] == i:
            for j in range(i * i, MAX, i):
                if spf[j] == j:
                    spf[j] = i

    # Массив: является ли число нечётно-степенным
    is_odd_power = [True] * MAX
    is_odd_power[0] = is_odd_power[1] = False  # 0 и 1 не натуральные в контексте задачи

    for x in range(2, MAX):
        n = x
        while n > 1:
            p = spf[n]
            cnt = 0
            while n % p == 0:
                n //= p
                cnt += 1
            if cnt % 2 == 0:
                is_odd_power[x] = False
                break
        # Если break не произошёл, is_odd_power[x] остаётся True

    # Поиск m подряд идущих в [l, r]
    count = 0
    start = -1
    for i in range(l, r + 1):
        if is_odd_power[i]:
            count += 1
            if count == 1:
                current_start = i
            if count == m:
                start = current_start
                break
        else:
            count = 0

    if start == -1:
        print(-1)
    else:
        print(' '.join(str(start + i) for i in range(m)))

if __name__ == "__main__":
    main()
