def solve():
    import sys
    input = sys.stdin.read
    data = input().split()
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])

    ans = [0] * k

    # Период k, но цвет = (s-2) % k, где s = i+j
    # Лучше считать s от 2 до n+m
    # Но проще сделать сдвиг: остаток от s % k

    # Функция для добавления cnt клеток с суммой s
    # Но мы будем работать с интервалами s

    # Определим три участка
    min_nm = min(n, m)
    max_nm = max(n, m)

    # 1) возрастающая часть: s от 2 до min_nm+1
    start1 = 2
    end1 = min_nm + 1
    # cnt(s) = s-1

    # 2) плато: s от min_nm+2 до max_nm+1
    start2 = min_nm + 2
    end2 = max_nm + 1
    # cnt(s) = min_nm

    # 3) убывающая часть: s от max_nm+2 до n+m
    start3 = max_nm + 2
    end3 = n + m
    # cnt(s) = n+m - s + 1

    # Обработаем каждый участок
    # Участок 1: cnt = s-1
    if start1 <= end1:
        for r in range(k):
            # Нужно найти все s на [start1, end1] с s % k == r
            # Но это арифметическая прогрессия с шагом k
            first = start1 + ((r - start1) % k + k) % k
            if first > end1:
                continue
            last = end1 - ((end1 - r) % k + k) % k
            if last < first:
                continue
            count = (last - first) // k + 1
            # Сумма cnt(s) = сумма (s-1) = сумма(s) - count
            # сумма(s) = (first+last)*count/2
            sum_s = (first + last) * count // 2
            ans[r] += sum_s - count * 1  # так как s-1

    # Участок 2: cnt = min_nm
    if start2 <= end2:
        const_val = min_nm
        for r in range(k):
            first = start2 + ((r - start2) % k + k) % k
            if first > end2:
                continue
            last = end2 - ((end2 - r) % k + k) % k
            if last < first:
                continue
            count = (last - first) // k + 1
            ans[r] += const_val * count

    # Участок 3: cnt = n+m - s + 1
    if start3 <= end3:
        total = n + m
        for r in range(k):
            first = start3 + ((r - start3) % k + k) % k
            if first > end3:
                continue
            last = end3 - ((end3 - r) % k + k) % k
            if last < first:
                continue
            count = (last - first) // k + 1
            sum_s = (first + last) * count // 2
            ans[r] += (total + 1) * count - sum_s

    # Ответ в порядке цветов 1..k
    print(' '.join(map(str, ans)))

if __name__ == "__main__":
    solve()
