def solve():
    import sys

    data = sys.stdin.read().strip().split()
    if not data:
        return

    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    N = 10**6 + 5

    lp = [0] * N
    primes = []
    for i in range(2,N):
        if lp[i] == 0:
            lp[i] = i
            primes.append(i)
        for p in primes:
            if p > lp[i] or i * p >= N:
                break
            lp[i * p] = p

    odd_powered = [False] * N
    odd_powered[1] = True

    for num in range(2, N):
        n = num
        ok = True
        while n > 1:
            p = lp[n]
            cnt = 0
            while n % p == 0:
                n //= p
                cnt += 1
            if cnt % 2 == 0:
                ok = False
                break
        odd_powered[num] = ok

    count_consecutive = 0
    found_start = -1
    for x in range(1, r + 1):
        if odd_powered[x]:
            count_consecutive += 1
            if count_consecutive >= m:
                found_start = x - m + 1
                break
        else:
            count_consecutive = 0


    if found_start == -1:
        print(-1)
    else:
        print(' '.join(str(found_start + i) for i in range(m)))


if __name__  == "__main__":
    solve()
        
