import math

def is_odd_power(n):

    if n == 1:
        return True

    temp = n
    for p in range(2, int(math.isqrt(n)) + 1):
        if temp % p == 0:
            cnt = 0
            while temp % p == 0:
                cnt += 1
                temp //= p
            if cnt % 2 == 0:  
                return False

    return True

def find_sequence(l, r, m):
    
    is_odd = []
    for i in range(l, r + 1):
        is_odd.append(is_odd_power(i))
    
    for start in range(len(is_odd) - m + 1):
        if all(is_odd[start:start + m]):
            
            result = [l + start + i for i in range(m)]
            return ' '.join(map(str, result))
    
    return '-1'


l, r, m = map(int, input().split())



print(find_sequence(l, r, m))
