import sys

def precompute(max_n):
    # Шаг 1: решето для наименьшего простого делителя
    lp = [0] * (max_n + 1)
    primes = []
    for i in range(2, max_n + 1):
        if lp[i] == 0:
            lp[i] = i
            primes.append(i)
        for p in primes:
            if p > lp[i] or i * p > max_n:
                break
            lp[i * p] = p

    # Шаг 2: проверка каждого числа на нечётно-степенность
    is_odd_power = [False] * (max_n + 1)
    
    for n in range(2, max_n + 1):
        temp = n
        valid = True
        
        while temp > 1:
            p = lp[temp]
            cnt = 0
            while temp % p == 0:
                cnt += 1
                temp //= p
            if cnt % 2 == 0:  # чётная степень
                valid = False
                break
        
        is_odd_power[n] = valid
    
    return is_odd_power

# Предварительно вычисляем для всех чисел до 10^6
MAX_N = 10**6
is_odd_power = precompute(MAX_N)

def solve():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())
    
    # Ищем первую последовательность из m подряд идущих нечётно-степенных чисел в [l, r]
    count = 0
    start = -1
    
    for n in range(l, r + 1):
        if is_odd_power[n]:
            count += 1
            if count == m:
                start = n - m + 1
                break
        else:
            count = 0  # сбрасываем счётчик
    
    if start == -1:
        print(-1)
    else:
        # Выводим m чисел: start, start+1, ..., start+m-1
        result = [str(start + i) for i in range(m)]
        print(' '.join(result))

if __name__ == '__main__':
    solve()
