def solve():
    import sys
    n = int(sys.stdin.readline())
    m = int(sys.stdin.readline())
    k = int(sys.stdin.readline())
    
    L = min(n, m)
    R = max(n, m)
    T = n + m - 1  # последняя диагональ
    
    # Массив для подсчёта количества клеток каждого цвета (индексация с 0, цвет 1 → индекс 0)
    count = [0] * k
    
    def sum_arithmetic(start, step, num_terms):
        """Сумма арифметической прогрессии: start + (start+step) + ... (num_terms слагаемых)"""
        if num_terms <= 0:
            return 0
        return num_terms * start + step * (num_terms - 1) * num_terms // 2
    
    # Участок 1: d ∈ [1, L], длина = d
    for c in range(1, k + 1):
        # Ищем первое d >= 1, где (d-1) mod k == c-1  → d ≡ c (mod k)
        d0 = c
        if d0 > L:
            continue
        # Последнее d <= L
        dn = c + ((L - c) // k) * k
        num_terms = ((dn - d0) // k) + 1
        # Сумма: d0 + (d0+k) + (d0+2k) + ... + dn
        total = sum_arithmetic(d0, k, num_terms)
        count[c - 1] += total
    
    # Участок 2: d ∈ [L+1, R], длина = L
    for c in range(1, k + 1):
        # Первое d >= L+1, где d ≡ c (mod k)
        rem = (c - (L + 1)) % k
        d0 = L + 1 + rem
        if d0 > R:
            continue
        # Последнее d <= R
        dn = c + ((R - c) // k) * k
        num_terms = ((dn - d0) // k) + 1
        total = num_terms * L
        count[c - 1] += total
    
    # Участок 3: d ∈ [R+1, T], длина = T + 1 - d
    for c in range(1, k + 1):
        # Первое d >= R+1, где d ≡ c (mod k)
        rem = (c - (R + 1)) % k
        d0 = R + 1 + rem
        if d0 > T:
            continue
        # Последнее d <= T
        dn = c + ((T - c) // k) * k
        num_terms = ((dn - d0) // k) + 1
        
        # Длина для d0: T+1 - d0; для d0+k: T+1 - (d0+k), и т.д.
        # Это арифметическая прогрессия с первым членом (T+1-d0), шагом (-k), num_terms членов
        first = T + 1 - d0
        total = sum_arithmetic(first, -k, num_terms)
        count[c - 1] += total
    
    # Вывод результатов (каждый цвет в отдельной строке)
    for x in count:
        print(x)


if __name__ == "__main__":
    solve()
