MOD = 10**9 + 7

def solve():
    n = int(input())
    rects = []
    for _ in range(n):
        x1, y1, x2, y2 = map(int, input().split())
        rects.append((x1, y1, x2, y2))
    
    if n == 1:
        return "Yes"
    

    global_y_low = max(r[1] for r in rects)
    global_y_high = min(r[3] for r in rects)
    if global_y_low <= global_y_high:
        return "Yes"
    

    global_x_low = max(r[0] for r in rects)
    global_x_high = min(r[2] for r in rects)
    if global_x_low <= global_x_high:
        return "Yes"
    
    def cross(ax, ay, bx, by, px, py):
        return (bx - ax) * (py - ay) - (by - ay) * (px - ax)
    
    def line_crosses_rect(A, B, rect):
        x1, y1, x2, y2 = rect
        corners = [(x1,y1), (x1,y2), (x2,y1), (x2,y2)]
        signs = []
        for px, py in corners:
            cp = cross(A[0], A[1], B[0], B[1], px, py)
            signs.append(cp)
        
        if all(s > 0 for s in signs) or all(s < 0 for s in signs):
            return False
        return True
    

    left_rect = min(rects, key=lambda r: r[0])   
    right_rect = max(rects, key=lambda r: r[2])  
    high_rect = max(rects, key=lambda r: r[3])   
    low_rect = min(rects, key=lambda r: r[1])    
    
    x1_l, y1_l, x2_l, y2_l = left_rect
    x1_r, y1_r, x2_r, y2_r = right_rect
    x1_h, y1_h, x2_h, y2_h = high_rect
    x1_lw, y1_lw, x2_lw, y2_lw = low_rect
    
    
    
    candidates = [
        ((x1_l, y2_l), (x2_r, y1_r)), 
        ((x1_l, y1_l), (x2_r, y2_r)), 
        ((x1_h, y2_h), (x2_lw, y1_lw)), 
        ((x1_h, y1_h), (x2_lw, y2_lw)), 
    ]
    
    for A, B in candidates:
        if all(line_crosses_rect(A, B, r) for r in rects):
            return "Yes"
    
    return "No"

T = int(input())
for _ in range(T):
    print(solve())
