mod = 10**9 + 7

# Ввод
import sys
n, K = map(int, input().split())
R = input().strip()

# Конвертируем R из десятичной строки в двоичную
# Python handle big integers! (так сделано в реальных олимпиадах)
if R == '0':
    bin_str = '0'
else:
    num = int(R)
    bin_str = bin(num)[2:]   # убираем '0b'

L = len(bin_str)

# dp0[r] = число чисел, уже строго меньших R, с popcount ≡ r mod K
# dp1[r] = число чисел, равных R до текущего бита, с popcount ≡ r mod K
dp0 = [0] * K
dp1 = [0] * K
dp1[0] = 1  # начальное состояние: "ничего не выбрано", popcount=0, равны R (пока пусто)

for bit in bin_str:
    new_dp0 = [0] * K
    new_dp1 = [0] * K

    for r in range(K):
        if dp1[r]:
            if bit == '1':
                # можно поставить 0 → число становится строго меньше
                new_dp0[(r + 0) % K] = (new_dp0[(r + 0) % K] + dp1[r]) % mod
                # можно поставить 1 → продолжаем быть равными R
                new_dp1[(r + 1) % K] = (new_dp1[(r + 1) % K] + dp1[r]) % mod
            else:  # bit == '0'
                # можно поставить только 0
                new_dp1[(r + 0) % K] = (new_dp1[(r + 0) % K] + dp1[r]) % mod
                # нельзя поставить 1, потому что превысим R
        if dp0[r]:
            # уже меньше → можно ставить любые биты
            new_dp0[(r + 0) % K] = (new_dp0[(r + 0) % K] + dp0[r]) % mod
            new_dp0[(r + 1) % K] = (new_dp0[(r + 1) % K] + dp0[r]) % mod

    dp0, dp1 = new_dp0, new_dp1

result = (dp0[0] + dp1[0]) % mod
print(result)
