max_n = 1000000

# Предвычисляем наименьшие простые делители
lpd = list(range(max_n + 1))
for i in range(2, int(max_n**0.5) + 1):
    if lpd[i] == i:
        for j in range(i * i, max_n + 1, i):
            if lpd[j] == j:
                lpd[j] = i

# Предвычисляем, является ли число нечётно-степенным
odd_power = [False] * (max_n + 1)
for n in range(2, max_n + 1):
    temp = n
    flag = True
    while temp > 1:
        p = lpd[temp]
        cnt = 0
        while temp % p == 0:
            cnt += 1
            temp //= p
        if cnt % 2 == 0:
            flag = False
            break
    odd_power[n] = flag

# Чтение
m = int(input())
l, r = map(int, input().split())

# Поиск первого отрезка длиной m
current_run = 0
start = -1

for i in range(l, r + 1):
    if odd_power[i]:
        current_run += 1
        if current_run == m:
            start = i - m + 1
            break
    else:
        current_run = 0

if start == -1:
    print(-1)
else:
    print(*range(start, start + m))
