def count_cells_per_color(n, m, k):
    colors_count = [0] * k  
    for diag_sum in range(2, n + m):
        length = min(diag_sum - 1, n, m)  
        start_row = max(1, diag_sum - m)
        end_row = min(diag_sum - 1, n)     
        num_cells_in_diag = end_row - start_row + 1 
        color_id = (diag_sum - 1) % k
        colors_count[color_id] += num_cells_in_diag
    return colors_count
n, m, k = map(int, input().split())
colors_result = count_cells_per_color(n, m, k)
print("\n".join(map(str, colors_result)))
