import sys

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    
    t = int(data[0])
    index = 1
    results = []
    
    for _ in range(t):
        n = int(data[index]); index += 1
        rects = []
        for i in range(n):
            x1 = int(data[index]); y1 = int(data[index+1]); x2 = int(data[index+2]); y2 = int(data[index+3])
            index += 4
            rects.append((x1, y1, x2, y2))
        
        if n == 1:
            results.append("Yes")
            continue
            
        corners = []
        for x1, y1, x2, y2 in rects:
            corners.append([
                (x1, y1), (x1, y2), (x2, y1), (x2, y2)
            ])
        
        found = False
        
        
        for x1, x2 in [(r[0], r[2]) for r in rects]:
            for x_val in [x1, x2]:
                ok = True
                for rx1, ry1, rx2, ry2 in rects:
                    if not (rx1 <= x_val <= rx2):
                        ok = False
                        break
                if ok:
                    found = True
                    break
            if found:
                break
                
        if found:
            results.append("Yes")
            continue
            
       
        for y1, y2 in [(r[1], r[3]) for r in rects]:
            for y_val in [y1, y2]:
                ok = True
                for rx1, ry1, rx2, ry2 in rects:
                    if not (ry1 <= y_val <= ry2):
                        ok = False
                        break
                if ok:
                    found = True
                    break
            if found:
                break
                
        if found:
            results.append("Yes")
            continue
            
       
        first_corners = corners[0]
        for i in range(1, n):
            for p1 in first_corners:
                for p2 in corners[i]:
                    
                    a = p2[1] - p1[1]
                    b = p1[0] - p2[0]
                    c = p1[1]*p2[0] - p2[1]*p1[0]
                    
                    ok = True
                    for rect in rects:
                        rx1, ry1, rx2, ry2 = rect
                        corners_rect = [(rx1, ry1), (rx1, ry2), (rx2, ry1), (rx2, ry2)]
                        signs = []
                        for pt in corners_rect:
                            val = a * pt[0] + b * pt[1] + c
                            signs.append(val)
                        
                        pos = any(s > 0 for s in signs)
                        neg = any(s < 0 for s in signs)
                        zero = any(s == 0 for s in signs)
                        
                        if not (pos or neg or zero):
                            ok = False
                            break
                        if pos and neg:
                            continue 
                        if zero:
                            continue  
                        
                        if not (pos or neg or zero):
                            ok = False
                            break
                    if ok:
                        found = True
                        break
                if found:
                    break
            if found:
                break
                
        results.append("Yes" if found else "No")
    
    for res in results:
        print(res)

if __name__ == "__main__":
    main()
