MOD = 10**9 + 7
def decimal_to_binary(decimal_str):
    if decimal_str == "0":
        return "0"
    num = int(decimal_str)
    binary = ""
    while num > 0:
        binary = str(num % 2) + binary
        num //= 2
    return binary
def solve(R_str, K):
    R_bin = decimal_to_binary(R_str)
    n = len(R_bin)
    dp = [[[0] * K for _ in range(2)] for _ in range(n + 1)]
    dp[0][1][0] = 1

    for pos in range(n):
        for tight in [0, 1]:
            for cnt in range(K):
                if dp[pos][tight][cnt] == 0:
                    continue
                max_bit = 1
                if tight == 1:
                    max_bit = int(R_bin[pos])
                for bit in [0, 1]:
                    if bit > max_bit:
                        continue
                    new_tight = 1 if (tight == 1 and bit == max_bit) else 0
                    new_cnt = (cnt + bit) % K
                    dp[pos + 1][new_tight][new_cnt] = (
                        dp[pos + 1][new_tight][new_cnt] + dp[pos][tight][cnt]
                    ) % MOD
    result = (dp[n][0][0] + dp[n][1][0]) % MOD
    return result
if __name__ == "__main__":
    n, K = map(int, input().split())
    R_str = input().strip()
    result = solve(R_str, K)
    print(result)
