MOD = 10 ** 9 + 7


def popcount(x):
    return bin(x).count('1')


def solve():
    n, K = map(int, input().split())
    R = input().strip()

    pow10_pop = [0] * (n + 1)
    power = 1
    for i in range(n + 1):
        pow10_pop[i] = popcount(power) % K
        power *= 10

    dp = {}
    dp[(0, True)] = 1

    for pos in range(n):
        next_dp = {}
        for state, cnt in dp.items():
            mod, tight = state
            max_digit = int(R[pos]) if tight else 9
            for d in range(0, max_digit + 1):
                new_tight = tight and (d == max_digit)
                exp = n - 1 - pos
                d_val = d * (10 ** exp)
                d_pop = popcount(d_val) % K
                new_mod = (mod + d_pop) % K
                new_state = (new_mod, new_tight)
                if new_state in next_dp:
                    next_dp[new_state] = (next_dp[new_state] + cnt) % MOD
                else:
                    next_dp[new_state] = cnt % MOD
        dp = next_dp

    result = 0
    for state, cnt in dp.items():
        mod, _ = state
        if mod == 0:
            result = (result + cnt) % MOD
    print(result)


solve()
