import math


def find_kth_magic_number(k):
    l = 1
    r = min((k ** 0.5) * 10 ** 17, 10 ** 18 + 1)

    def count_magic_numbers(x):
        div_by_7 = x // 7
        end_with_7 = (x + 3) // 10
        both = (x + 63) // 70
        return div_by_7 + end_with_7 - both

    while l < r:
        m = (l + r) // 2
        current_count = count_magic_numbers(m)

        if current_count >= k:
            r = m
        else:
            l = m + 1

    return l


if __name__ == "__main__":
    k = int(input().strip())
    answer = find_kth_magic_number(k)
    print(answer)