import sys


def solve():
    try:
        line1 = sys.stdin.readline()
        if not line1:
            return

        parts = list(map(int, line1.split()))
        if not parts:
            line1 = sys.stdin.readline()
            if not line1:
                return
            parts = list(map(int, line1.split()))

        if not parts:
            return

        n, K = parts
        R_str = sys.stdin.readline().strip()
        if not R_str:
            return

        R_int = int(R_str)
        B = bin(R_int)[2:]

        len_B = len(B)
        MOD = 1000000007

        memo = {}

        def count_valid(index, current_popcount_mod_K, is_tight):
            if index == len_B:
                return 1 if current_popcount_mod_K == 0 else 0

            state = (index, current_popcount_mod_K, is_tight)
            if state in memo:
                return memo[state]

            result = 0
            limit = int(B[index]) if is_tight else 1

            for digit in range(limit + 1):
                next_tight = is_tight and (digit == limit)
                next_popcount_mod_K = (current_popcount_mod_K + digit) % K

                result = (result + count_valid(index + 1, next_popcount_mod_K, next_tight)) % MOD

            memo[state] = result
            return result

        print(count_valid(0, 0, True))

    except EOFError:
        pass
    except ValueError:
        pass


solve()
