import sys
import math


def read_ints():
    for line in sys.stdin:
        for x in line.split():
            yield x
    return


def solve_final():
    reader = read_ints()
    try:
        m = int(next(reader))
        l = int(next(reader))
        r = int(next(reader))
    except StopIteration:
        print("-1")
        return
    except ValueError:
        print("-1")
        return

    R = r
    spf = [i for i in range(R + 1)]
    for i in range(2, int(math.sqrt(R)) + 1):
        if spf[i] == i:
            for j in range(i * i, R + 1, i):
                if spf[j] == j:
                    spf[j] = i

    op_status = [False] * (r - l + 1)
    for n in range(l, r + 1):
        temp = n
        distinct_primes = set()
        while temp > 1:
            p = spf[temp]
            distinct_primes.add(p)
            while temp % p == 0:
                temp //= p

        product_of_primes = 1
        for p in distinct_primes:
            product_of_primes *= p

        if n % product_of_primes == 0:
            S_squared = n // product_of_primes
            S = int(math.isqrt(S_squared))
            if S * S == S_squared:
                op_status[n - l] = True

    count = 0
    start_num = -1
    for i_rel in range(r - l + 1):
        if op_status[i_rel]:
            if count == 0:
                start_num = l + i_rel
            count += 1
            if count >= m:
                print(*(list(range(start_num, start_num + m))))
                return
        else:
            count = 0
            start_num = -1

    print("-1")


if __name__ == "__main__":
    solve_final()
