﻿program GreatBeam;

const
  MAX_N = 400000;
  EPS = 1e-6;

var
  T, n, i, j, k, p1, p2, cnt: longint;
  x1, y1, x2, y2: array[1..MAX_N] of int64;
  px, py: array[1..8] of int64;  // углы первых двух прямоугольников
  A, B, C: double;

// Проверка, лежит ли точка (x,y) на прямой Ax + By + C = 0
function IsPointOnLine(x, y: int64): boolean;
begin
  IsPointOnLine := abs(A * x + B * y + C) < EPS;
end;

// Проверка пересечения прямой с отрезком (x1,y1)-(x2,y2)
function LineIntersectsSegment(x1, y1, x2, y2: int64): boolean;
var
  f1, f2: double;
begin
  f1 := A * x1 + B * y1 + C;
  f2 := A * x2 + B * y2 + C;
  LineIntersectsSegment := (f1 * f2 <= EPS);  // разные знаки или один ноль
end;

// Проверяет, касается ли прямая всех прямоугольников
function CheckAllRectangles: boolean;
var
  i: longint;
  touched: boolean;
begin
  for i := 1 to n do
  begin
    touched := false;
    
    // Проверяем углы
    if IsPointOnLine(x1[i], y1[i]) then touched := true;
    if IsPointOnLine(x2[i], y1[i]) then touched := true;
    if IsPointOnLine(x1[i], y2[i]) then touched := true;
    if IsPointOnLine(x2[i], y2[i]) then touched := true;
    
    // Если углы не на прямой — проверяем стороны
    if not touched then
    begin
      if LineIntersectsSegment(x1[i], y1[i], x2[i], y1[i]) then touched := true;  // нижняя
      if LineIntersectsSegment(x2[i], y1[i], x2[i], y2[i]) then touched := true;  // правая
      if LineIntersectsSegment(x2[i], y2[i], x1[i], y2[i]) then touched := true;  // верхняя
      if LineIntersectsSegment(x1[i], y2[i], x1[i], y1[i]) then touched := true;  // левая
    end;
    
    if not touched then
    begin
      CheckAllRectangles := false;
      exit;
    end;
  end;
  CheckAllRectangles := true;
end;

// Строит прямую по двум точкам
procedure BuildLine(x1, y1, x2, y2: int64);
begin
  A := y2 - y1;
  B := x1 - x2;
  C := -(A * x1 + B * y1);
end;

begin
  readln(T);
  
  while T > 0 do
  begin
    readln(n);
    
    for i := 1 to n do
      readln(x1[i], y1[i], x2[i], y2[i]);
    
    // Случай n = 1
    if n = 1 then
    begin
      writeln('Yes');
      dec(T);
      continue;
    end;
    
    // Собираем углы первых двух прямоугольников (максимум 8 точек)
    cnt := 0;
    for k := 1 to 2 do
    begin
      if k > n then break;
      cnt := cnt + 1; px[cnt] := x1[k]; py[cnt] := y1[k];
      cnt := cnt + 1; px[cnt] := x2[k]; py[cnt] := y1[k];
      cnt := cnt + 1; px[cnt] := x1[k]; py[cnt] := y2[k];
      cnt := cnt + 1; px[cnt] := x2[k]; py[cnt] := y2[k];
    end;
    
    // Перебираем все пары точек
    for p1 := 1 to cnt do
      for p2 := p1 + 1 to cnt do
      begin
        BuildLine(px[p1], py[p1], px[p2], py[p2]);
        
        if CheckAllRectangles then
        begin
          writeln('Yes');
          break;
        end;
      end;
    
    // Если ни одна прямая не подошла
    if (p1 > cnt) or (p2 > cnt) then
      writeln('No');
    
    dec(T);
  end;
end.


