﻿program NonEvenPowerNumbers;
var
  m, l, r, x, len, start, p, cnt: longint;
  found: boolean;

// Функция: проверяет, является ли x нечётно-степенным
function IsNonEvenPower(x: longint): boolean;
var
  temp, p, power: longint;
begin
  temp := x;
  p := 2;
  while p * p <= temp do
  begin
    if temp mod p = 0 then
    begin
      power := 0;
      while temp mod p = 0 do
      begin
        temp := temp div p;
        power := power + 1;
      end;
      // Если степень чётная — число не подходит
      if power mod 2 = 0 then
      begin
        IsNonEvenPower := false;
        exit;
      end;
    end;
    p := p + 1;
  end;
  // Если остался простой множитель > sqrt(x) (например, простое число)
  if temp > 1 then
  begin
    // Его степень = 1 (нечётная) — всё ок
  end;
  IsNonEvenPower := true;
end;

begin
  // Ввод
  readln(m);
  readln(l, r);
  
  // Инициализация
  len := 0;
  start := -1;
  found := false;
  
  // Перебираем числа от l до r
  for x := l to r do
  begin
    if IsNonEvenPower(x) then
    begin
      // Число подходит — увеличиваем длину последовательности
      len := len + 1;
      // Если это начало новой последовательности — запоминаем начало
      if len = 1 then
        start := x;
      
      // Если набрали m подряд — выводим и завершаем
      if len >= m then
      begin
        found := true;
        // Выводим m чисел: от start до start + m - 1
        for cnt := 0 to m - 1 do
        begin
          if cnt > 0 then
            write(' ');
          write(start + cnt);
        end;
        writeln;
        break;
      end;
    end
    else
    begin
      // Число не подходит — сбрасываем длину последовательности
      len := 0;
    end;
  end;
  
  // Если ничего не нашли — выводим -1
  if not found then
    writeln(-1);
end.
