﻿program KthMagicNumber;
var
  k, L, R, mid, ans: int64;

function CountMagicUpTo(N: int64): int64;
begin
  if N < 1 then
    CountMagicUpTo := 0
  else
    CountMagicUpTo := (N div 7) + ((N + 3) div 10) - ((N + 63) div 70);
end;

function FindKthMagic(k: int64): int64;
begin
  L := 1;
  R := 7 * k;  // Верхняя граница: k-е магическое <= 7*k
  ans := R;
  
  while L <= R do
  begin
    mid := (L + R) div 2;
    if CountMagicUpTo(mid) >= k then
    begin
      ans := mid;
      R := mid - 1;
    end
    else
      L := mid + 1;
  end;
  
  FindKthMagic := ans;
end;

begin
  // Ввод
  readln(k);
  
  // Вычисление и вывод результата
  writeln(FindKthMagic(k));
end.
