﻿
program ColorDiagonals;

var
  n, m, k, d, len, i, fullCycles, rem: int64;
  colors: array[1..5] of int64;

function min(a, b: int64): int64;
begin
  if a < b then Result := a else Result := b;
end;

function max(a, b: int64): int64;
begin
  if a > b then Result := a else Result := b;
end;

procedure AddToColor(col, count: int64);
begin
  colors[col] := colors[col] + count;
end;

begin
  read(n, m, k);
  
  for i := 1 to k do
    colors[i] := 0;
  
  d := n + m - 1;
  len := min(n, m);
  
  for i := 1 to len - 1 do
    AddToColor((i - 1) mod k + 1, i);

  if len <= d - len + 1 then begin
    fullCycles := (d - len + 1 - len + 1) div k;
    rem := (d - len + 1 - len + 1) mod k;
    
    for i := 1 to k do
      colors[i] := colors[i] + fullCycles * len;
    
    for i := 0 to rem - 1 do
      AddToColor(((len + i - 1) mod k) + 1, len);
  end;
  
  for i := d - len + 2 to d do
    AddToColor((i - 1) mod k + 1, d - i + 1);
  
  for i := 1 to k do
    writeln(colors[i]);
end.
