﻿
program ColorDiagonals;

var
  n, m, k, d, len, i, fullCycles, rem: int64;
  colors: array[1..5] of int64;

function min(a, b: int64): int64;
begin
  if a < b then Result := a else Result := b;
end;

function max(a, b: int64): int64;
begin
  if a > b then Result := a else Result := b;
end;

// Вспомогательная: добавить count клеток к цвету col
procedure AddToColor(col, count: int64);
begin
  colors[col] := colors[col] + count;
end;

begin
  read(n, m, k);
  
  // Обнуляем счётчики цветов
  for i := 1 to k do
    colors[i] := 0;
  
  // Общее число диагоналей: от 1 до n+m-1
  d := n + m - 1;
  // Максимальная длина диагонали
  len := min(n, m);
  
  // Разбиваем диагонали на три зоны:
  // 1. Растущая: от 1 до len-1 (длина = номер диагонали)
  // 2. Постоянная: от len до d-len+1 (длина = len)
  // 3. Убывающая: от d-len+2 до d (длина = d - номер + 1)

  // Зона 1: растущие диагонали (1 .. len-1)
  for i := 1 to len - 1 do
    AddToColor((i - 1) mod k + 1, i);
  
  // Зона 2: постоянные диагонали (len .. d - len + 1)
  if len <= d - len + 1 then begin
    fullCycles := (d - len + 1 - len + 1) div k;
    rem := (d - len + 1 - len + 1) mod k;
    
    // Полные циклы
    for i := 1 to k do
      colors[i] := colors[i] + fullCycles * len;
    
    // Остаток
    for i := 0 to rem - 1 do
      AddToColor(((len + i - 1) mod k) + 1, len);
  end;
  
  // Зона 3: убывающие диагонали (d-len+2 .. d)
  for i := d - len + 2 to d do
    AddToColor((i - 1) mod k + 1, d - i + 1);
  
  // Выводим результаты
  for i := 1 to k do
    writeln(colors[i]);
end.
