﻿program ColorDiagonals;

var
  n, m, k, i, d, startD, endD: int64;
  colors: array[1..5] of int64;

begin
  read(n, m, k);
  
  // Инициализируем счётчики цветов
  for i := 1 to k do
    colors[i] := 0;
  
  // Диагонали идут от 2 до n+m
  startD := 2;
  endD := n + m;
  
  for d := startD to endD do begin
    // Количество клеток на диагонали d
    if d <= n + 1 then begin
      if d <= m + 1 then
        i := d - 1  // обе границы "свободны"
      else
        i := m;     // ограничена по m
    end else begin
      if d > m then
        i := n + m - d + 1  // ограничена по обеим сторонам
      else
        i := n;     // ограничена по n
    end;
    
    // Определяем цвет диагонали (1..k)
    colors[(d - 1) mod k + 1] := colors[(d - 1) mod k + 1] + i;
  end;
  
  // Выводим результаты
  for i := 1 to k do
    writeln(colors[i]);
end.
