import sys

sys.set_int_max_str_digits(2000000)

MOD = 10 ** 9 + 7


def solve_optimized():
    try:
        line1 = sys.stdin.readline()
        if not line1: return
        parts = list(map(int, line1.split()))

        if not parts:
            line1 = sys.stdin.readline()
            if not line1: return
            parts = list(map(int, line1.split()))

        if len(parts) == 2:
            n, K = parts
            R_str = sys.stdin.readline().strip()
        else:
            return

        R_int = int(R_str)
        B_STR = bin(R_int)[2:]
        L = len(B_STR)

        if K == 0:
            print(1 if R_int >= 0 else 0)
            return

        dp_tight = [0] * K
        dp_loose = [0] * K
        dp_tight[0] = 1

        for i in range(L):
            new_dp_tight = [0] * K
            new_dp_loose = [0] * K
            upper_bound_digit = int(B_STR[i])

            for rem in range(K):
                if dp_tight[rem] > 0:
                    for digit in range(upper_bound_digit + 1):
                        new_rem = (rem + digit) % K
                        if digit < upper_bound_digit:
                            new_dp_loose[new_rem] = (new_dp_loose[new_rem] + dp_tight[rem]) % MOD
                        else:

                            new_dp_tight[new_rem] = (new_dp_tight[new_rem] + dp_tight[rem]) % MOD

                if dp_loose[rem] > 0:

                    for digit in [0, 1]:
                        new_rem = (rem + digit) % K
                        new_dp_loose[new_rem] = (new_dp_loose[new_rem] + dp_loose[rem]) % MOD

            dp_tight = new_dp_tight
            dp_loose = new_dp_loose
        result = (dp_tight[0] + dp_loose[0]) % MOD
        print(result)

    except EOFError:
        pass
    except ValueError:
        pass


solve_optimized()
