import sys
from functools import lru_cache


sys.setrecursionlimit(2000000)
sys.set_int_max_str_digits(2000000)

MOD = 10 ** 9 + 7
GLOB_K = 0
B_STR = ""

@lru_cache(None)
def salve(index, current_k, is_less):
    if index == len(B_STR):
        return 1 if current_k == 0 else 0

    upper_bound = int(B_STR[index]) if not is_less else 1
    count = 0

    for digit in range(upper_bound + 1):
        new_is_less = is_less or (digit < upper_bound)
        new_k = (current_k + digit) % GLOB_K

        count = (count + salve(index + 1, new_k, new_is_less)) % MOD

    return count


def solve():
    global B_STR, GLOB_K

    try:
        line1 = sys.stdin.readline()
        if not line1: return
        parts = list(map(int, line1.split()))

        if not parts:
            line1 = sys.stdin.readline()
            if not line1: return
            parts = list(map(int, line1.split()))

        if len(parts) == 2:
            n, K = parts
            R_str = sys.stdin.readline().strip()
        else:
            return

        GLOB_K = K

        R_int = int(R_str)
        B_STR = bin(R_int)[2:]

        if K == 0:

            print(1 if R_int >= 0 else 0)
            return
        result = salve(0, 0, False)
        print(result)
        salve.cache_clear()

    except EOFError:
        pass
    except ValueError:
        pass


solve()
