import sys

sys.set_int_max_str_digits(200000)
sys.setrecursionlimit(200000)

MOD = 10 ** 9 + 7
MEMO = {}
B_STR = ""
GLOB_K = 0

# иронично то как, без рекурсии никак, но рекурсия при этом кушает много памяти O(N)
def salve(index, current_k, is_less):
    if index == len(B_STR):
        return 1 if current_k == 0 else 0

    state = (index, current_k, is_less)
    if state in MEMO:
        return MEMO[state]

    upper_bound = int(B_STR[index]) if not is_less else 1
    count = 0

    for digit in range(upper_bound + 1):
        new_is_less = is_less or (digit < upper_bound)
        new_k = (current_k + digit) % GLOB_K
        count = (count + salve(index + 1, new_k, new_is_less)) % MOD

    MEMO[state] = count
    return count


def solve():
    global B_STR, GLOB_K, MEMO

    try:
        line1 = sys.stdin.readline()
        if not line1: return
        parts = list(map(int, line1.split()))

        if not parts:
            line1 = sys.stdin.readline()
            if not line1: return
            parts = list(map(int, line1.split()))

        if len(parts) == 2:
            n, K = parts
            R_str = sys.stdin.readline().strip()
        else:
            return

        GLOB_K = K
        R_int = int(R_str)
        B_STR = bin(R_int)[2:]

        if K == 0:
            print(1)
            return

        result = salve(0, 0, False)
        print(result)

    except EOFError:
        pass
    except ValueError:
        pass


solve()
