﻿
#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <functional>
#include <bit>
#include <string>
constexpr int mod = (int)1e9 + 7;
using namespace std;
int bin_pow(int base, int exp) {
	int result = 1;
	while (exp) {
		if (exp & 1)
			result = (long long)result * base % mod;
		base = (long long)base * base % mod;
		exp >>= 1;
	}
	return result;
}
int main()
{
	int n, K;
	std::cin >> n >> K;
	int d = n * 3.4 + 1;
	string R;
	cin >> R;
	std::vector<bool> bitR;
	bool R_isnt_zero = true;
	while (R_isnt_zero) {
		const unsigned int bits_from_div = 59;
		R_isnt_zero = false;
		string result;
		unsigned long long remainder = 0;
		unsigned long long divisor = 1ULL << bits_from_div;
		for (auto c : R) {
			remainder *= 10;
			remainder += c - '0';
			char d = remainder / divisor;
			remainder = remainder % divisor;
			if (d)
				R_isnt_zero = true;
			result.push_back(d + '0');
		}
		swap(result, R);
		for (int d = bits_from_div - 1; d >= 0; d--) {
			bitR.push_back(remainder & (1ULL << d));
		}
	}
	reverse(bitR.begin(), bitR.end());
	d = bitR.size();
	std::vector<int> facts(d + 1);
	std::vector<int> inv_facts(d + 1);
	facts[0] = 1;
	for (int i = 1; i <= d; i++) {
		facts[i] = (long long)facts[i - 1] * i % mod;
	}
	inv_facts[d] = bin_pow(facts[d], mod - 2);
	for (int i = d - 1; i >= 0; i--) {
		inv_facts[i] = (long long)inv_facts[i + 1] * (i + 1) % mod;
	}
	function<int(int, int, int)>  get_without_r = [&facts, &inv_facts](int n, int K, int m) {
		int result = 0;
		for (int i = m; i <= n; i += K) {
			result = ((long long)facts[n] * inv_facts[n - i] % mod * inv_facts[i] + result) % mod;
		}
		return result;
	};
	function<int(int, int, int)> get = [&get, &get_without_r, &bitR](int n, int K, int m) {
		if (n == 0)
			return (int)(m == 0);
		if (bitR[n - 1]) {
			int m2 = m - 1;
			if (m2 < 0)
				m2 += K;
			return (get_without_r(n-1, K, m) + get(n - 1, K, m2)) % mod;
		}
		return get(n - 1, K, m);
	};
	cout << get(d, K, 0) << '\n';
}