﻿
#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <functional>
#include <bit>
constexpr int mod = (int)1e9 + 7;
using namespace std;
int bin_pow(int base, int exp) {
	int result = 1;
	while (exp) {
		if (exp & 1)
			result = (long long)result * base % mod;
		base = (long long)base * base % mod;
		exp >>= 1;
	}
	return result;
}
int main()
{
	int n, K;
	std::cin >> n >> K;
	int d = n * 3.4 + 1;
	unsigned long long R;
	cin >> R;
	std::vector<bool> bitR(d, false);
	for (int b = min(d - 1, 63); b >= 0; b--) {
		bitR[b] = R & (1ULL << b);
	}
	std::vector<int> facts(d + 1);
	std::vector<int> inv_facts(d + 1);
	facts[0] = 1;
	for (int i = 1; i <= d; i++) {
		facts[i] = (long long)facts[i - 1] * i % mod;
	}
	inv_facts[d] = bin_pow(facts[d], mod - 2);
	for (int i = d - 1; i >= 0; i--) {
		inv_facts[i] = (long long)inv_facts[i + 1] * (i + 1) % mod;
	}
	function<int(int, int, int)>  get_without_r = [&facts, &inv_facts](int n, int K, int m) {
		int result = 0;
		for (int i = m; i <= n; i += K) {
			result = ((long long)facts[n] * inv_facts[n - i] % mod * inv_facts[i] + result) % mod;
		}
		return result;
	};
	function<int(int, int, int)> get = [&get, &get_without_r, &bitR](int n, int K, int m) {
		if (n == 0)
			return (int)(m == 0);
		if (bitR[n - 1]) {
			int m2 = m - 1;
			if (m2 < 0)
				m2 += K;
			return (get_without_r(n-1, K, m) + get(n - 1, K, m2)) % mod;
		}
		return get(n - 1, K, m);
	};
	cout << get(d, K, 0) << '\n';
}