
#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <functional>
#include <bit>
#include <string>
constexpr int mod = (int)1e9 + 7;
typedef __uint128_t div_int;
using namespace std;
int bin_pow(int base, int exp) {
	int result = 1;
	while (exp) {
		if (exp & 1)
			result = (long long)result * base % mod;
		base = (long long)base * base % mod;
		exp >>= 1;
	}
	return result;
}
int main()
{
	int n, K;
	std::cin >> n >> K;
	int d = n * 3.4 + 1;
	string R;
    string result;
    result.reserve(n);
	cin >> R;
	std::vector<bool> bitR;
	bool R_isnt_zero = true;
	while (R_isnt_zero) {
        result.clear();
		const unsigned int bits_from_div = 120;
		R_isnt_zero = false;
		div_int remainder = 0;
		div_int divisor = ((div_int)1) << bits_from_div;
		for (auto c : R) {
			remainder *= 10;
			remainder += c - '0';
			char d = remainder / divisor;
			remainder = remainder % divisor;
			if (d)
				R_isnt_zero = true;
			result.push_back(d + '0');
		}
		swap(result, R);
		for (int d = 0; d < bits_from_div; d++) {
			bitR.push_back(remainder & (((div_int)1) << d));
		}
	}
	d = bitR.size();
	std::vector<int> facts;
	std::vector<int> inv_facts;
	std::vector<int> dp;
    function<int(int, int, int)>  get_without_r;
    if (K >= 500){
        facts.resize(d);
        inv_facts.resize(d);
        facts[0] = 1;
        for (int i = 1; i <= d; i++) {
            facts[i] = (long long)facts[i - 1] * i % mod;
        }
        inv_facts[d] = bin_pow(facts[d], mod - 2);
        for (int i = d - 1; i >= 0; i--) {
            inv_facts[i] = (long long)inv_facts[i + 1] * (i + 1) % mod;
        }
        get_without_r = [&facts, &inv_facts](int n, int K, int m) {
            int result = 0;
            for (int i = m; i <= n; i += K) {
                result = ((long long)facts[n] * inv_facts[n - i] % mod * inv_facts[i] + result) % mod;
            }
            return result;
        };
    }
	else {
		dp.resize(d * K);
		dp[0] = 1;
		for (int i = 1; i < d*K; i++) {
            if (i % K == 0){
                dp[i] = (dp[i-1] + dp[i-K]) % mod;
            }
            else
                dp[i] = (dp[i-K-1] + dp[i-K]) % mod;
		}
		get_without_r = [&dp](int n, int K, int m) {
			return dp[n*K+m];
			};
	}
	function<int(int, int, int)> get = [&get, &get_without_r, &bitR](int n, int K, int m) {
		if (n == 0)
			return (int)(m == 0);
		if (bitR[n - 1]) {
			int m2 = m - 1;
			if (m2 < 0)
				m2 += K;
			return (get_without_r(n-1, K, m) + get(n - 1, K, m2)) % mod;
		}
		return get(n - 1, K, m);
	};
	cout << get(d, K, 0) << '\n';
}